/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.node;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.SudoManager;
import com.aptana.ide.core.io.downloader.DownloadManager;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodeJSService;
import com.aptana.js.internal.core.node.Messages;
import com.aptana.js.internal.core.node.NodeJS;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class NodeJSService
implements INodeJSService {
    private static final String LIB = "lib";
    private static final String APPDATA_NPM_PATH = "%APPDATA%\\npm";
    private static final String PROGRAM_FILES_X86_NODEJS_NODE_PATH = "%ProgramFiles(x86)%\\nodejs";
    private static final String PROGRAM_FILES_NODEJS_NODE_PATH = "%PROGRAMFILES%\\nodejs";
    private static final String USR_LOCAL_BIN_NODE = "/usr/local/bin";
    private static final String REGISTRY_PATH_NODE_JS = "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Node.js";
    private static final String REG_NODEJS_INSTALL_KEY = "InstallPath";
    private static final String NODE_EXE = "node.exe";
    private static final String NPM_EXE = "npm.cmd";
    private static final String MAC_NODE_URL = "http://go.appcelerator.com/installer_nodejs_osx";
    private static final String WIN_NODE_URL = "http://go.appcelerator.com/installer_nodejs_windows.msi";
    private static final String MAC_EXTENSION = ".pkg";
    private static final String WIN_EXTENSION = ".msi";
    private final Set<INodeJSService.NodeJsListener> listeners = new LinkedHashSet<INodeJSService.NodeJsListener>();
    private final Map<IPath, INodeJS> nodeJsInstalls = new HashMap<IPath, INodeJS>();
    private INodeJS fNodeExePath = this.findValidExecutable();

    private boolean isNpmInstalled() {
        IPath path = null;
        if (PlatformUtil.isWindows()) {
            IPath regPath;
            String installedPath = PlatformUtil.queryRegistryStringValue((String)REGISTRY_PATH_NODE_JS, (String)REG_NODEJS_INSTALL_KEY);
            if (!StringUtil.isEmpty((String)installedPath) && (regPath = Path.fromOSString((String)installedPath).append(NPM_EXE)).toFile().exists()) {
                return true;
            }
            path = ExecutableUtil.find((String)NPM_EXE, (boolean)false, (List)CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)PROGRAM_FILES_NODEJS_NODE_PATH)), Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)PROGRAM_FILES_X86_NODEJS_NODE_PATH))}));
        } else {
            path = ExecutableUtil.find((String)"npm", (boolean)false, (List)CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)USR_LOCAL_BIN_NODE)}));
        }
        return path != null && path.toFile().exists();
    }

    public INodeJS detectInstall() {
        IPath path = null;
        if (PlatformUtil.isWindows()) {
            IPath regPath;
            INodeJS install;
            String installedPath = PlatformUtil.queryRegistryStringValue((String)REGISTRY_PATH_NODE_JS, (String)REG_NODEJS_INSTALL_KEY);
            if (!StringUtil.isEmpty((String)installedPath) && (install = this.getNodeJsInstall(regPath = Path.fromOSString((String)installedPath).append(NODE_EXE))).exists()) {
                return install;
            }
            path = ExecutableUtil.find((String)NODE_EXE, (boolean)false, (List)CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)PROGRAM_FILES_NODEJS_NODE_PATH)), Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)PROGRAM_FILES_X86_NODEJS_NODE_PATH))}));
        } else {
            path = ExecutableUtil.find((String)"node", (boolean)false, (List)CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)USR_LOCAL_BIN_NODE)}));
        }
        if (path == null) {
            return null;
        }
        return this.getNodeJsInstall(path);
    }

    private synchronized INodeJS getNodeJsInstall(IPath path) {
        if (this.nodeJsInstalls.containsKey(path)) {
            return this.nodeJsInstalls.get(path);
        }
        NodeJS nodeJs = new NodeJS(path);
        this.addListener(nodeJs);
        this.nodeJsInstalls.put(path, nodeJs);
        return nodeJs;
    }

    public IStatus install(char[] password, IProgressMonitor monitor) {
        URI uri;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NodeJSService_InstallingJobTitle, (int)100);
        if (!PlatformUtil.isWindows() && !PlatformUtil.isMac()) {
            return new Status(4, "com.aptana.js.core", Messages.NodeJSService_CannotInstallOnLinuxMsg);
        }
        String rawURL = PlatformUtil.isWindows() ? WIN_NODE_URL : MAC_NODE_URL;
        String extension = PlatformUtil.isWindows() ? WIN_EXTENSION : MAC_EXTENSION;
        try {
            uri = new URI(rawURL);
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Bad Download URI for node: {0}", rawURL), (Throwable)e);
            return new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodeJSService_BadURLError, rawURL), (Throwable)e);
        }
        try {
            IStatus status;
            File file = this.download(uri, extension, (IProgressMonitor)sub.newChild(90));
            if (PlatformUtil.isWindows()) {
                status = new ProcessRunner().runInBackground((IPath)Path.ROOT, new String[]{"msiexec", "/i", file.getAbsolutePath()});
            } else {
                List args = new SudoManager().getArguments(password);
                CollectionsUtil.addToList((List)args, (Object[])new String[]{"/usr/sbin/installer", "-pkg", file.getAbsolutePath(), "-target", "/"});
                status = this.createProcessRunner().run((IPath)Path.ROOT, null, password, args, (IProgressMonitor)sub.newChild(95));
            }
            if (!status.isOK()) {
                String message = status instanceof ProcessStatus ? ((ProcessStatus)status).getStdErr() : status.getMessage();
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)("Failed to install NodeJS: " + message));
                return new Status(4, "com.aptana.js.core", Messages.NodeJSService_InstallFailedError);
            }
            if (PlatformUtil.isWindows()) {
                ShellExecutable.updatePathEnvironment((String[])new String[]{PROGRAM_FILES_NODEJS_NODE_PATH, PROGRAM_FILES_X86_NODEJS_NODE_PATH, APPDATA_NPM_PATH});
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e);
        }
        sub.done();
        this.fireNodeJSInstalled();
        this.fNodeExePath = this.findValidExecutable();
        return Status.OK_STATUS;
    }

    protected IProcessRunner createProcessRunner() {
        return new ProcessRunner();
    }

    private File download(URI uri, String extension, IProgressMonitor monitor) throws CoreException {
        DownloadManager manager = new DownloadManager();
        IPath path = Path.fromPortableString((String)uri.getPath());
        String name = path.lastSegment();
        File f = new File(FileUtil.getTempDirectory().toFile(), String.valueOf(name) + extension);
        f.deleteOnExit();
        manager.addURI(uri, f);
        IStatus status = manager.start(monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        List locations = manager.getContentsLocations();
        return ((IPath)locations.get(0)).toFile();
    }

    public INodeJS getInstallFromPreferences() {
        String pref = InstanceScope.INSTANCE.getNode("com.aptana.js.core").get("nodejs_path", null);
        if (StringUtil.isEmpty((String)pref)) {
            return null;
        }
        IPath path = Path.fromOSString((String)pref);
        if (path.toFile().isDirectory()) {
            path = path.append(PlatformUtil.isWindows() ? NODE_EXE : "node");
        }
        return this.getNodeJsInstall(path);
    }

    public INodeJS getValidExecutable() {
        return this.getValidExecutable(false);
    }

    public INodeJS getValidExecutable(boolean isforce) {
        if (isforce) {
            if (this.fNodeExePath != null) {
                this.nodeJsInstalls.remove(this.fNodeExePath.getPath());
                this.listeners.remove(this.fNodeExePath);
                this.fNodeExePath = null;
            }
            return this.findValidExecutable();
        }
        return this.fNodeExePath;
    }

    private INodeJS findValidExecutable() {
        INodeJS nodeExePath = this.getInstallFromPreferences();
        if (nodeExePath != null && nodeExePath.validate().isOK()) {
            this.fNodeExePath = nodeExePath;
        }
        if ((nodeExePath = this.detectInstall()) != null && nodeExePath.validate().isOK()) {
            this.fNodeExePath = nodeExePath;
        }
        return this.fNodeExePath;
    }

    public boolean isInstalled() {
        if (!this.isNpmInstalled()) {
            return false;
        }
        INodeJS nodeExePath = this.getInstallFromPreferences();
        if (nodeExePath != null && nodeExePath.exists()) {
            return true;
        }
        nodeExePath = this.detectInstall();
        return nodeExePath != null && nodeExePath.exists();
    }

    public void addListener(INodeJSService.NodeJsListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(INodeJSService.NodeJsListener listener) {
        this.listeners.remove(listener);
    }

    private void fireNodeJSInstalled() {
        for (INodeJSService.NodeJsListener listener : this.listeners) {
            listener.nodeJSInstalled();
        }
    }

    public IStatus validateSourcePath(IPath path) {
        if (path == null || path.isEmpty()) {
            return new Status(4, "com.aptana.js.core", Messages.NodeJSService_EmptySourcePath);
        }
        if (!path.toFile().isDirectory()) {
            return new Status(4, "com.aptana.js.core", 1, MessageFormat.format(Messages.NodeJSService_NoDirectory_0, path), null);
        }
        if (!path.append(LIB).toFile().isDirectory()) {
            return new Status(4, "com.aptana.js.core", MessageFormat.format(Messages.NodeJSService_InvalidLocation_0, LIB));
        }
        return Status.OK_STATUS;
    }

    public IStatus acceptBinary(IPath nodeJSBinary) {
        return this.getNodeJsInstall(nodeJSBinary).validate();
    }
}

